<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:param name="xslConvertToCY" select="cif:xslConvertToCY"/>
    
    <!-- Variable to hold cubic factor -->
    <xsl:variable name="cubicFactor">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'">
                <xsl:choose>
                    <xsl:when test="$xslConvertToCY = 1">27</xsl:when>
                    <xsl:otherwise>1</xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <!-- Volumes Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis objemu</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis objemu komponent modelu koridoru</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Cross Section Set Data -->
                            <xsl:for-each select="CrossSectionSet">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Název koridoru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@setName"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název trasy:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@alignmentName"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">
                                                    <xsl:choose>
                                                        <xsl:when test="$xslConvertToCY = 1">
                                                            ve stopách, čtverečních stopách a yardech krychlových,
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            ve stopách, čtverečních stopách a stopách krychlových,
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">
                                                    v metrech, metrech čtverečních a metrech krychlových,
                                                </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Volume Data -->
                                <table class="margin" width="90%">
                                    <xsl:for-each select="CrossSectionStations">
                                        <thead style="display:table-header-group">
                                            <tr>
                                                <th colspan="2">&#xa0;</th>
                                                <th colspan="2" lang="en" valign="bottom" align="center">Plocha/Objem komponent Celkem</th>
                                                <th colspan="2" lang="en" valign="bottom" align="center">Plocha komponent Celkem</th>
                                                <th colspan="2">&#xa0;</th>
                                            </tr>
                                            <tr>
                                                <th class="underline" lang="en" valign="bottom" align="left">Staničení</th>
                                                <th class="underline" lang="en" valign="bottom" align="right">Materiál</th>
                                                <th class="underline" lang="en" valign="bottom" align="right">Plocha</th>
                                                <th class="underline" lang="en" valign="bottom" align="right">Objem</th>
                                                <th class="underline" lang="en" valign="bottom" align="right">Délka</th>
                                                <th class="underline" lang="en" valign="bottom" align="right">Plocha</th>
                                                <th class="underline" lang="en" valign="bottom" align="right">Jednotková cena</th>
                                                <th class="underline" lang="en" valign="bottom" align="right">Materiálová cena</th>
                                            </tr>
                                        </thead>
                                        <xsl:for-each select="CrossSectionStation">
                                            <tbody>
                                                <xsl:apply-templates/>
                                            </tbody>
                                            <tfoot style="display:table-footer-group">
                                                <xsl:if test="position() = last()">
                                                    <xsl:for-each select="StationVolume">
                                                        <tr><td colspan="8"><hr/></td></tr>
                                                        <tr>
                                                            <th align="left">Celkem:</th>
                                                        </tr>
                                                        <xsl:apply-templates mode="final"/>
                                                        <tr>
                                                            <th colspan="7" align="right">
                                                                Celkové odhadované náklady:                                                           
                                                            </th>
                                                            <th  align="right">
                                                                <xsl:value-of select="cif:formatNumber(number(//@totalCost), 2)"/>
                                                            </th>
                                                        </tr>
                                                        
                                                    </xsl:for-each>
                                                </xsl:if>
                                            </tfoot>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template match="StationVolume">
        <tr>
            <th align="left" nowrap="nowrap">
                <xsl:value-of select="cif:stationFormat(number(../Station/@externalStation), string(../Station/@externalStationName))"/>
            </th>
            <td colspan="5">&#xa0;</td>
        </tr>
        <xsl:apply-templates mode="normalParent"/>
        <tr><td>&#xa0;</td></tr>
    </xsl:template>
    <xsl:template match="Material" mode="normalParent">
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="@name"/>:&#xa0; </td>
            <xsl:choose>
                <xsl:when test="@area != 0.0">
                    <td align="right">
                        <xsl:value-of select="cif:areaFormat(number(@area))"/>
                    </td>
                </xsl:when>
                <xsl:otherwise>
                     <td>&#xa0;</td>
                 </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="@volume != 0.0">
                    <td align="right">
                        <xsl:value-of select="cif:cubicFormat(number(@volume div $cubicFactor))"/>
                    </td>
                </xsl:when>
                <xsl:otherwise>
                     <td>&#xa0;</td>
                 </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="@length != 0.0">
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                    </td>
                </xsl:when>
                <xsl:otherwise>
                     <td>&#xa0;</td>
                 </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="@linearArea != 0.0">
                    <td align="right">
                        <xsl:value-of select="cif:areaFormat(number(@linearArea))"/>
                    </td>
                </xsl:when>
                <xsl:otherwise>
                     <td>&#xa0;</td>
                 </xsl:otherwise>
            </xsl:choose>
            <td align="right">
                <xsl:choose>
                    <xsl:when test="@volume != 0.0">
                        <xsl:value-of select="cif:formatNumber(number(@unitCost), 2)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="cif:formatNumber(number(@unitCost), 2)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <td align="right">
                <xsl:value-of select="cif:cubicFormat(number((@volume div $cubicFactor + @linearArea) * @unitCost), 2)"/>
            </td>
        </tr>
    </xsl:template>
    <xsl:template match="Material" mode="final">
        <tr>
            <td align="right" colspan="2"><xsl:value-of select="@name"/>:&#xa0; </td>
            <xsl:choose>
                <xsl:when test="@cumulativeVolume != 0.0">
                    <td colspan="2" align="right">
                        <xsl:value-of select="cif:cubicFormat(number(@cumulativeVolume div $cubicFactor))"/>
                    </td>
                </xsl:when>
                <xsl:otherwise>
                    <td colspan="2">&#xa0;</td>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="@cumulativeArea != 0.0">
                    <td colspan="2" align="right">
                        <xsl:value-of select="cif:cubicFormat(number(@cumulativeArea))"/>
                    </td>
                </xsl:when>
                <xsl:otherwise>
                    <td colspan="2">&#xa0;</td>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="@volume != 0.0">
                    <td align="right">
                        <xsl:value-of select="cif:formatNumber(number(@unitCost), 2)"/>
                    </td>
                </xsl:when>
                <xsl:otherwise>
                    <td align="right">
                        <xsl:value-of select="cif:formatNumber(number(@unitCost), 2)"/>
                    </td>
                </xsl:otherwise>
            </xsl:choose>
            <td align="right">
                <xsl:value-of select="cif:cubicFormat(number((@cumulativeArea + @cumulativeVolume div $cubicFactor) * @unitCost), 2)"/>
            </td>
        </tr>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
            Pro výpis <em>Kalkulace komponent</em> musíte zvolit tlačítko <em>Výpis </em> v tomto příkazu.         
                Alternativně můžete tento výpis otevřít v Průzkumník Civil výpisů, pokud byl již výpis komponent vytvořen. 
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
